% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitmapfont.r
\name{read.AmigaBitmapFontSet}
\alias{read.AmigaBitmapFontSet}
\title{Read AmigaBitmapFontSet from *.font file}
\usage{
read.AmigaBitmapFontSet(file, disk = NULL, ...)
}
\arguments{
\item{file}{A \code{character} string of the filename of the *.font file to be read.}

\item{disk}{A virtual Commodore Amiga disk from which the \code{file} should be
read. This should be an \code{\link[adfExplorer:amigaDisk-class]{amigaDisk}} object. Using
this argument requires the adfExplorer package.
When set to \code{NULL}, this argument is ignored.}

\item{...}{Currently ignored.}
}
\value{
Returns an \code{\link{AmigaBitmapFontSet}} object read from the specified file.
}
\description{
Reads \code{\link{AmigaBitmapFontSet}} from *.font file including
all nested bitmap images for all font heights.
}
\details{
The *.font file only holds meta-information. The bitmap images for
each font height are stored in separate files, which are listed
in the *.font file. The function reads the *.font file, including
all nested bitmap files and returns it as a
\code{\link{AmigaBitmapFontSet}}.

It can also read *.font files
from \code{\link[adfExplorer]{amigaDisk-class}} objects,
but that requires the adfExplorer package to be installed.
}
\examples{
\dontrun{
data(font_example)

## in order to read, we first need to write a file"
write.AmigaBitmapFontSet(font_example, tempdir())

## The font is written as 'AmigaFFH.font' as that name
## is embedded in the AmigaBitmapFontSet object 'font_example'.
## We can read it as follows:
font.read <- read.AmigaBitmapFontSet(file.path(tempdir(), "AmigaFFH.font"))

## similarly, the file can also be written and read from and to
## a virtual amiga disk. The following codes requires the 'adfExplorer'
## package:
adf <- adfExplorer::blank.amigaDOSDisk("font.disk")
adf <- adfExplorer::dir.create.adf(adf, "FONTS")
adf <- write.AmigaBitmapFontSet(font_example, "DF0:FONTS", adf)
font.read <- read.AmigaBitmapFontSet("DF0:FONTS/AmigaFFH.font", adf)
}
}
\seealso{
Other AmigaBitmapFont.operations: 
\code{\link{AmigaBitmapFont}},
\code{\link{availableFontSizes}()},
\code{\link{c}()},
\code{\link{fontName}()},
\code{\link{font_example}},
\code{\link{getAmigaBitmapFont}()},
\code{\link{rasterToAmigaBitmapFont}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{write.AmigaBitmapFont}()}

Other io.operations: 
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasicShape}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaIcon}()},
\code{\link{read.SysConfig}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasicShape}()},
\code{\link{write.AmigaBasic}()},
\code{\link{write.AmigaBitmapFont}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.SysConfig}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBitmapFont.operations}
\concept{io.operations}
