% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{read.AmigaBasicShape}
\alias{read.AmigaBasicShape}
\title{Read Amiga Basic Shape files}
\usage{
read.AmigaBasicShape(file, disk = NULL, ...)
}
\arguments{
\item{file}{A \code{character} string of the filename of the Amiga Basic Shape file to be read.}

\item{disk}{A virtual Commodore Amiga disk from which the \code{file} should be
read. This should be an \code{\link[adfExplorer:amigaDisk-class]{amigaDisk()}} object. Using
this argument requires the adfExplorer package.
When set to \code{NULL}, this argument is ignored.}

\item{...}{Arguments passed to \code{\link[=rawToAmigaBasicShape]{rawToAmigaBasicShape()}}.}
}
\value{
Returns an \code{\link[=AmigaBasicShape]{AmigaBasicShape()}} class object read from the \code{file}.
}
\description{
Read Amiga Basic Shape files
}
\details{
AmigaBasic used the term 'shapes' for graphics (sprites and blitter objects) which it could display.
These graphics were stored in a specific binary format, which can be read with this function. See
\code{\link[=AmigaBasicShape]{AmigaBasicShape()}} for more details. The file can also be read from a virtual Amiga disk
(\code{\link[adfExplorer:amigaDisk-class]{amigaDisk()}}).
}
\examples{
\dontrun{
filename <- system.file("ball.shp", package = "AmigaFFH")
ball     <- read.AmigaBasicShape(filename)
## This is a sprite:
ball$flags[["fVSprite"]]

filename <- system.file("r_logo.shp", package = "AmigaFFH")
## The palette is not stored with an Amiga Basic Shape, so let's provide one:
r_logo   <- read.AmigaBasicShape(filename,
                                 palette = c("#FFFFFF", "#2266BB", "#3366BB", "#4477AA",
                                 "#778899", "#999999", "#AAAAAA", "#BBBBBB"))
## This is a blitter object:
r_logo$flags[["fVSprite"]]

## Just for fun, plot it:
plot(r_logo)
}
}
\seealso{
Other AmigaBasicShape.operations: 
\code{\link{AmigaBasicShape}},
\code{\link{rasterToAmigaBasicShape}()},
\code{\link{write.AmigaBasicShape}()}

Other io.operations: 
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaIcon}()},
\code{\link{read.SysConfig}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasicShape}()},
\code{\link{write.AmigaBasic}()},
\code{\link{write.AmigaBitmapFont}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.SysConfig}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasicShape.operations}
\concept{io.operations}
