% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BonferroniTest.R
\name{BonferroniTest}
\alias{BonferroniTest}
\title{Bonferroni-Corrected Pairwise t-Tests}
\usage{
BonferroniTest(modelo, alpha = 0.05)
}
\arguments{
\item{modelo}{An object of class \code{aov} or \code{lm}.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"bonferroni"} and \code{"comparaciones"}, containing:
\itemize{
  \item \code{Resultados}: Data frame with comparisons, mean differences, t-values, unadjusted and adjusted p-values, and significance.
  \item \code{Promedios}: Named numeric vector of group means.
  \item \code{Orden_Medias}: Group names ordered from highest to lowest mean.
  \item \code{Metodo}: Name of the method used ("Bonferroni-adjusted t-test").
}
}
\description{
Performs pairwise t-tests with Bonferroni adjustment for multiple comparisons.
This method controls the family-wise error rate by dividing the alpha level
by the number of comparisons.
}
\details{
Advantages:
- Very simple and easy to implement.
- Strong control of Type I error.
- Applicable to any set of independent comparisons.

Disadvantages:
- Highly conservative, especially with many groups.
- Can lead to low statistical power (increased Type II error).
- Does not adjust test statistics, only p-values.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- BonferroniTest(mod)
summary(resultado)

}
\references{
Dunn, O. J. (1964). Multiple Comparisons Using Rank Sums. \emph{Technometrics}, 6(3), 241–252. \doi{10.1080/00401706.1964.10490181}

Wilcoxon, F. (1945). Individual Comparisons by Ranking Methods. \emph{Biometrics Bulletin}, 1(6), 80–83. \doi{10.2307/3001968}
}
