% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahn_plot.R
\name{ahn_plot}
\alias{ahn_plot}
\title{Plot networks}
\usage{
ahn_plot(ahn, NodeLabels = unname(V(ahn)), NodeColors = unname(V(ahn)),
  NodeSizes = rep(3, length(V(ahn))))
}
\arguments{
\item{ahn}{Networks returned by \code{\link{ahn_gen}}}

\item{NodeLabels}{The labels of nodes in \code{ahn} (node IDs by default)}

\item{NodeColors}{The colors of nodes in \code{ahn} (each node has a unique color by default)}

\item{NodeSizes}{The sizes of nodes in \code{ahn} (nodes are with the identical size of 3 by default)}
}
\value{
Return a plot of the network
}
\description{
Visualise networks generated by the function \code{\link{ahn_gen}}.
}
\examples{
# generate a weighted and connected network and plot it by default
N <- 10
x <- runif(N, 0, 5)
ahn <- ahn_gen(N, L = 5, mu = 1, lamda = 5, X = x)
ahn_plot(ahn)

\donttest{

# plot the network with specified colors, labels and sizes for nodes
ahn_plot(
ahn,
NodeColors = sample(4, N, replace = TRUE),
NodeLabels = letters[1:N],
NodeSizes = seq(1, 5, length.out = N))

}

}
