% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3Classes.R
\name{original_file}
\alias{original_file}
\title{Check for an original mcmc file}
\usage{
original_file(x, ...)
}
\arguments{
\item{x}{An \code{archaeophases_mcmc} object.}

\item{...}{Either a path to a CSV file, a connection,
or the value \code{clipboard()} to read from the system clipboard.
The CSV \code{file} can be compressed or plain.}
}
\value{
A boolean, \code{TRUE} if the files match, \code{FALSE}
otherwise.
}
\description{
Checks whether or not a file is identical to the one used to create
an \code{archaeophases_mcmc} object.
}
\examples{
\dontrun{
rem <- read_chronomodel("http://tsdye.online/AP/cm/Chain_all_Events.csv")
original_file(rem, "http://tsdye.online/AP/cm/Chain_all_Events.csv")
}

}
\author{
Thomas S. Dye, \email{tsd@tsdye.online}
}
