% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localmeshdiff.R
\name{localmeshdiff}
\alias{localmeshdiff}
\title{localmeshdiff
Calculate and Visualize local differences between two meshes}
\usage{
localmeshdiff(
  mesh1,
  mesh2,
  ploton,
  paltot = rainbow(200),
  from = NULL,
  to = NULL,
  n.int = 200,
  out.rem = TRUE,
  fact = 1.5,
  visual = 1,
  scale01 = TRUE,
  colwire = "pink"
)
}
\arguments{
\item{mesh1}{reference mesh: object of class "mesh3d"}

\item{mesh2}{target mesh: object of class "mesh3d"}

\item{ploton}{numeric: define which mesh will be used to visualize local differences}

\item{paltot}{character vector: specify the colors which are used to create a color palette}

\item{from}{numeric: minimum distance to be colorised}

\item{to}{numeric: maximum distance to be colorised}

\item{n.int}{numeric: determines break points for color palette}

\item{out.rem}{logical: if TRUE outliers will be removed}

\item{fact}{numeric: factor k of the interquartile range}

\item{visual}{numeric: if equals to 1 the mesh is plotted without a wireframe, if set on 2 a wireframe is added}

\item{scale01}{logical: if TRUE the vector of distances is scaled from 0 to 1}

\item{colwire}{character: color of the wireframe}
}
\value{
vect numeric vector containing local differeces in area between the reference and the target mesh
}
\description{
localmeshdiff
Calculate and Visualize local differences between two meshes
}
\references{
Melchionna, M., Profico, A., Castiglione, S., Sansalone, G., Serio, C., Mondanaro, A., ... & Manzi, G. (2020). 
From smart apes to human brain boxes. A uniquely derived brain shape in late hominins clade. Frontiers in Earth Science, 8, 273.
}
\author{
Antonio Profico, Costantino Buzi, Silvia Castiglione, Marina Melchionna, Paolo Piras, Pasquale Raia, Alessio Veneziano
}
