% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tactical_JPM5.R
\name{tactical_JPM5}
\alias{tactical_JPM5}
\title{Calculates asset allocations for the JPMorgan ETF Efficiente® 5 portfolio.}
\usage{
tactical_JPM5(strat, reb_date, P, R, risk_free = NULL)
}
\arguments{
\item{strat}{A list representing an asset allocation strategy.}

\item{reb_date}{A date on which the allocation rule is applied.}

\item{P}{An xts object with daily prices of the tickers in strat.}

\item{R}{An xts object with daily returns of the tickers in strat.}

\item{risk_free}{Either an xts object with daily returns of the risk-free
asset, or a scalar numeric with the annual risk-free rate in decimals.}
}
\value{
A numeric vector of weights after applying the rule.
}
\description{
\code{tactical_JPM5} determines asset allocations using a replication
of the JPMorgan ETF Efficiente® 5 index methodology described in publicly
available documentation (<https://sp.jpmorgan.com/spweb/content/307403.pdf>).
}
\details{
The strategy uses a window of six months of daily data to compute inputs to
perform a constrained mean-variance optimization. It relies on the
\code{mvFrontier} function from the \code{NMOF} package.
}
\examples{
JPM_Eff5  <- asset_allocations$tactical$JPM_Eff5
reb_date <- as.Date("2022-03-31")
tactical_JPM5(JPM_Eff5, reb_date, ETFs$Prices[, JPM_Eff5$tickers], ETFs$Returns[, JPM_Eff5$tickers])
}
