% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{get_storage_account}
\alias{get_storage_account}
\alias{list_storage_accounts}
\title{Get existing Azure storage account(s)}
\description{
Methods for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} and \link[AzureRMR:az_subscription]{AzureRMR::az_subscription} classes.
}
\section{Usage}{
\preformatted{get_storage_account(name)
list_storage_accounts()
}
}

\section{Arguments}{

\itemize{
\item \code{name}: For \code{get_storage_account()}, the name of the storage account.
}
}

\section{Details}{

The \code{AzureRMR::az_resource_group} class has both \code{get_storage_account()} and \code{list_storage_accounts()} methods, while the \code{AzureRMR::az_subscription} class only has the latter.
}

\section{Value}{

For \code{get_storage_account()}, an object of class \code{az_storage} representing the storage account.

For \code{list_storage_accounts()}, a list of such objects.
}

\examples{
\dontrun{

rg <- AzureRMR::az_rm$
    new(tenant="myaadtenant.onmicrosoft.com", app="app_id", password="password")$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# get a storage account
rg$get_storage_account("mystorage")

}
}
\seealso{
\link{create_storage_account}, \link{delete_storage_account}, \link{az_storage},
\href{https://docs.microsoft.com/en-us/rest/api/storagerp/}{Azure Storage Provider API reference}
}
