% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer_format_utils.R
\name{storage_write_delim}
\alias{storage_write_delim}
\alias{storage_write_csv}
\alias{storage_write_csv2}
\alias{storage_read_delim}
\alias{storage_read_csv}
\alias{storage_read_csv2}
\title{Read and write a data frame to/from a storage account}
\usage{
storage_write_delim(object, container, file, delim = "\\t", ...)

storage_write_csv(object, container, file, ...)

storage_write_csv2(object, container, file, ...)

storage_read_delim(container, file, delim = "\\t", ...)

storage_read_csv(container, file, ...)

storage_read_csv2(container, file, ...)
}
\arguments{
\item{object}{A data frame to write to storage.}

\item{container}{An Azure storage container object.}

\item{file}{The name of a file in storage.}

\item{delim}{For \code{storage_write_delim} and \code{storage_read_delim}, the field delimiter. Defaults to \verb{\\t} (tab).}

\item{...}{Optional arguments passed to the file reading/writing functions. See 'Details'.}
}
\description{
Read and write a data frame to/from a storage account
}
\details{
These functions let you read and write data frames to storage. \code{storage_read_delim} and \code{write_delim} are for reading and writing arbitrary delimited files. \code{storage_read_csv} and \code{write_csv} are for comma-delimited (CSV) files. \code{storage_read_csv2} and \code{write_csv2} are for files with the semicolon \verb{;} as delimiter and comma \verb{,} as the decimal point, as used in some European countries.

If the readr package is installed, they call down to \code{read_delim}, \code{write_delim}, \code{read_csv2} and \code{write_csv2}. Otherwise, they use \code{read_delim} and \code{write.table}.
}
\examples{
\dontrun{

bl <- storage_endpoint("https://mystorage.blob.core.windows.net/", key="access_key")
cont <- storage_container(bl, "mycontainer")

storage_write_csv(iris, cont, "iris.csv")
# if readr is not installed
irisnew <- storage_read_csv(cont, "iris.csv", stringsAsFactors=TRUE)
# if readr is installed
irisnew <- storage_read_csv(cont, "iris.csv", col_types="nnnnf")

all(mapply(identical, iris, irisnew))  # TRUE

}
}
\seealso{
\link{storage_download}, \link{download_blob}, \link{download_azure_file}, \link{download_adls_file},
\link{write.table}, \link{read.csv}, \link[readr:write_delim]{readr::write_delim}, \link[readr:read_delim]{readr::read_delim}
}
