% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_diagnostics.R
\name{contour.angmcmc}
\alias{contour.angmcmc}
\title{Contour plot for angmcmc objects with bivariate data}
\usage{
\method{contour}{angmcmc}(x, fn = mean, show.data = TRUE, nlevels = 20,
  levels, burnin = 1/3, thin = 1, cex = 1, col = "red", ...)
}
\arguments{
\item{x}{angular MCMC object (with bivariate data).}

\item{fn}{function to evaluate on MCMC samples to estimate parameters.  Defaults to \code{mean}, which computes the estimated posterior mean.}

\item{show.data}{logical. Should the data points be added to the contour plot? Ignored if \code{object} is NOT supplied.}

\item{nlevels}{number of contour levels desired \strong{if} levels is not supplied;
passed to the \link{contour} function in graphics.}

\item{levels}{numeric vector of levels at which to draw contour lines;
passed to the \link{contour} function in graphics.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}

\item{cex, col}{graphical parameters passed to \code{\link{points}} in graphics for plotting the data points.
Ignored if {show.data == FALSE}.}

\item{...}{additional arguments to be passed to the function \code{\link{contour}}.}
}
\description{
Contour plot for angmcmc objects with bivariate data
}
\details{
\code{contour.angmcmc} is an S3 function for angmcmc objects that calls \code{\link{contour}} from graphics.

To estimate the mixture density required to construct the contour plot, first the parameter vector \eqn{\eta} is estimated
by applying \code{fn} on the MCMC samples, yielding the (consistent) Bayes estimate \eqn{\hat{\eta}}. Then the mixture density
\eqn{f(x|\eta)} at any point \eqn{x} is (consistently) estimated by \eqn{f(x|\hat{\eta})}.
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
# now create a contour plot with the default first 1/3 as burn-in and thin = 1
contour(fit.vmsin.20)

}

