% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_postprodn_fns.R
\name{WAIC}
\alias{WAIC}
\title{Watanabe-Akaike Information Criterion (WAIC) for angmcmc objects}
\usage{
WAIC(object, form = 1, burnin = 1/3, thin = 1, ...)
}
\arguments{
\item{object}{angular MCMC object.}

\item{form}{the form of p_W to use. Available choices are 1 (default) and 2. See details.}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}

\item{...}{additional model specific arguments to be passed to \code{WAIC}. For example, \code{int.displ}
specifies integer dispacement in wnorm and wnorm2 models. See \link{fit_wnormmix} and
\link{fit_wnorm2mix} for more details.}
}
\value{
Computes the WAIC for a given angmcmc object.
}
\description{
Watanabe-Akaike Information Criterion (WAIC) for angmcmc objects
}
\details{
Given a deviance function \eqn{D(\eta) = -2 \log(p(y|\eta))}, and an estimate
\eqn{\eta* = (\sum \eta_i) / n} of the posterior mean
\eqn{E(\eta|y)}, where \eqn{y = (y_1, ..., y_n)} denote the data, \eqn{\eta} is the unknown
parameter vector of the model, \eqn{\eta_1, ..., \eta_N} are MCMC samples from the posterior
distribution of \eqn{\eta} given \eqn{y} and \eqn{p(y|\eta)} is the likelihood function,
the Watanabe-Akaike Information Criterion (WAIC) is defined as
\deqn{WAIC = LPPD - p_W}
where
\deqn{LPPD  = \sum_{i=1}^n \log (N^{-1} \sum_{s=1}^N p(y_i|\eta_s) )}
and (form 1 of)
\deqn{p_W =  2 \sum_{i=1}^n [ \log (N^{-1} \sum_{s=1}^N p(y_i|\eta_s) ) - N^{-1} \sum_{s=1}^N \log \:p(y_i|\eta_s) ].}
An alternative form (form 2) for \eqn{p_W} is given by
\deqn{p_W = \sum_{i=1}^n \hat{var} \log p(y_i|\eta)}
where for \eqn{i = 1, ..., n}, \eqn{\hat{var} \log p(y_i|\eta)} denotes the estimated variance
of \eqn{\log p(y_i|\eta)} based on the realizations \eqn{\eta_1, ..., \eta_N}.
}
\examples{
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             ncores = 1)
WAIC(fit.vmsin.20)

}
