% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getJenksBreaks.R
\name{getJenksBreaks}
\alias{getJenksBreaks}
\title{Jenks natural breaks classification}
\usage{
getJenksBreaks(var, k, subset = NULL)
}
\arguments{
\item{var}{Numeric vector.}

\item{k}{Number of breaks.}

\item{subset}{Number of regularly spaced samples to subset from
\code{var}. Intended to improve runtime for large datasets. If
\code{NULL}, all values are used.}
}
\value{
A numeric vector of intervals.
}
\description{
Given a vector of numeric values and the number of desired
    breaks, calculate the optimum breakpoints using Jenks natural
    breaks optimization.
}
\details{
\code{getJenksBreaks} is called by
    \code{\link{assignColorBreaks}}.

    The values in \code{var} are binned into \code{k+1} categories,
    according to the Jenks natural breaks classification method. This
    method is borrowed from the field of cartography, and seeks to
    minimize the variance within categories, while maximizing the variance
    between categories. If \code{subset = NULL}, all values of \code{var}
    are used for the optimization, however this can be a slow process with
    very large datasets. If \code{subset} is set to some number, then 
    \code{subset} regularly spaced values of \code{var} will be sampled.
    This is slightly less accurate than when using the entirety of
    \code{var} but is unlikely to make much of a difference. If 
    \code{subset} is defined but \code{length(var) < subset}, then
    \code{subset} has no effect.  

    The Jenks natural breaks method was ported to C from code found in the
    classInt R package.
}
\examples{
# load whales dataset
data(whales, events.whales)
ed <- getEventData(whales, events.whales, burnin=0.25, nsamples=500)

# for demonstration purposes, extract the vector of speciation rates
ed <- dtRates(ed, tau=0.01)
vec <- ed$dtrates$rates[[1]]

# Return breaks for the binning of speciation rates into 65 groups
# yielding 64 breaks
getJenksBreaks(vec, 64)
}
\author{
Pascal Title
}
\seealso{
See \code{\link{assignColorBreaks}} and
    \code{\link{plot.bammdata}}.
}
\keyword{graphics}

