% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{Bayes.outlier}
\alias{Bayes.outlier}
\title{Bayesian Outlier Detection}
\usage{
Bayes.outlier(lmobj, k = 3)
}
\arguments{
\item{lmobj}{An object of class `lm`}

\item{k}{number of standard deviations used in calcuating
default is `k=3`,}
}
\value{
Returns a list of three items:
\item{e}{residuals}
\item{hat}{leverage values}
\item{pr}{posterior probabilities of a point being an outlier}
}
\description{
Calculate the posterior  probability that the absolute value of
error exceeds more than k standard deviations
P(|epsilon_j| > k sigma | data)
under the model Y = X B + epsilon,
with epsilon ~ N(0, sigma^2 I)
based on the paper
by Chaloner & Brant Biometrika (1988).
This only uses the reference prior p(B, sigma) = 1;
other priors and model averaging to come.
}
\examples{
library(MASS)
data(stackloss)
stack.lm =lm(stack.loss ~ ., data=stackloss)
stack.outliers = Bayes.outlier(stack.lm)
plot(stack.outliers$pr, type="h", ylab="Posterior Probability")
}
\references{
Chaloner & Brant (1988)
A Bayesian Approach to Outlier Detection and Residual Analysis
Biometrika (1988) 75, 651-659
}
