% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_priors.R
\name{beta.binomial}
\alias{beta.binomial}
\alias{Beta.Binomial}
\title{Beta-Binomial Prior Distribution for Models}
\usage{
beta.binomial(alpha = 1, beta = 1)
}
\arguments{
\item{alpha}{parameter in the beta prior distribution}

\item{beta}{parameter in the beta prior distribution}
}
\value{
returns an object of class "prior", with the family and
hyperparameters.
}
\description{
Creates an object representing the prior distribution on models for BAS.
}
\details{
The beta-binomial distribution on model size is obtained by assigning each
variable inclusion indicator independent Bernoulli distributions with
probability w, and then giving w a beta(alpha,beta) distribution.
Marginalizing over w leads to the distribution on model size having the
beta-binomial distribution. The default hyperparameters lead to a uniform
distribution over model size.
}
\examples{
beta.binomial(1, 10) #' @family priors modelpriors
}
\seealso{
\code{\link{bas.lm}}, \code{\link{Bernoulli}},\code{\link{uniform}}

Other priors modelpriors: \code{\link{Bernoulli.heredity}},
  \code{\link{Bernoulli}}, \code{\link{tr.beta.binomial}},
  \code{\link{tr.poisson}}, \code{\link{tr.power.prior}},
  \code{\link{uniform}}
}
\author{
Merlise Clyde
}
\concept{priors modelpriors}
