% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAT.R
\name{sim.spatial}
\alias{sim.spatial}
\title{Simulation of species spatial distributions.}
\usage{
sim.spatial(n, s, sad = "lognormal", sd = 1, distribution = "aggregated",
  clust = 1)
}
\arguments{
\item{n}{total number of individuals.}

\item{s}{number of species.}

\item{sad}{The SAD distribution type (lognormal, uniform, broken stick or geometric). Default is lognormal.}

\item{sd}{The standard deviation of lognormal distributions. Default is 1.}

\item{distribution}{The spatial distribution of individual species populations (aggregated, random, uniform or gradient). Default is aggregated.}

\item{clust}{The clustering parameter (higher values create more clustered populations). Default is 1.}
}
\value{
A matrix of individuals x (species, x coords and y coords).
}
\description{
Creates artificial communities with given SAD and spatial clustering.
}
\details{
The spatial distribution of individuals of given species may take a number of forms.
Competitive exclusion may cause overdispersion, specific habitat needs or cooperation may cause aggregation and environmental gradients may cause abundance gradients.
}
\examples{
par(mfrow = c(3 ,3))
comm = sim.spatial(100, 9, distribution = "uniform")
for(i in 1:9){
	sp <- comm[comm[1] == paste("Sp", i, sep = ""), ]
	plot(sp$x, sp$y, main = paste("Sp", i), xlim = c(0,1), ylim = c(0,1))
}
comm = sim.spatial(1000, 9, sad = "lognormal", sd = 0.5, distribution = "aggregated", clust = 2)
for(i in 1:9){
	sp <- comm[comm[1] == paste("Sp", i, sep=""), ]
	plot(sp$x, sp$y, main = paste("Sp", i), xlim = c(0,1), ylim = c(0,1))
}
}

