% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraping_games_euro.R
\name{scraping_games_euro}
\alias{scraping_games_euro}
\title{Euroleague and Eurocup player game finder data}
\usage{
scraping_games_euro(competition, nums, year, verbose = TRUE,
                    r_user = "guillermo.vinue@uv.es")
}
\arguments{
\item{competition}{String. Options are "Euroleague" and "Eurocup".}

\item{nums}{Numbers corresponding to the website from which scraping.}

\item{year}{Year when the season starts. 2017 refers to 2017-2018 and so on.}

\item{verbose}{Should R report information on progress? Default TRUE.}

\item{r_user}{Email to identify the user when doing web scraping. 
This is a polite way to do web scraping and to certify that the user 
is working as transparently as possible with a research purpose.}
}
\value{
A data frame with the player game finder data.
}
\description{
This function allows us to get all the player game finder data for 
all the desired Euroleague and Eurocup seasons available from
\url{https://www.euroleague.net/main/results/} and
\url{https://www.eurocupbasketball.com/eurocup/games/results/}, respectively.
}
\details{
See the examples in \code{\link{get_games_rosters}} to see the game numbers
to scrape in each season.
}
\note{
In addition to use the email address to stay identifiable, the function also 
contains two headers regarding the R platform and version used.

Furthermore, in the robots.txt file located at
\url{https://www.euroleague.net/robots.txt} and 
\url{https://www.eurocupbasketball.com/robots.txt}
there is the Crawl-delay field which asks crawlers to pause between 
requests for 15 seconds. This is done by adding to the function the command
\code{Sys.sleep(15)}.
}
\examples{
\dontrun{
# Not needed to scrape every time the package is checked, built and installed.
# It takes 15 seconds as it is required in https://www.euroleague.net/robots.txt
df1 <- do_scraping_games(competition = "Euroleague", nums = 1:2, 
                         year = "2017", verbose = TRUE, r_user = 
                         "guillermo.vinue@uv.es")
}

}
\seealso{
\code{\link{do_scraping_games}}
}
\author{
Guillermo Vinue
}
