% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_prepare_data_gradient.R
\name{do_prepare_data_gradient}
\alias{do_prepare_data_gradient}
\title{Prepare the data for the gradient shooting plots}
\usage{
do_prepare_data_gradient(all_shots_pl, summary_shots_zone_pl, summary_shots_zone_league)
}
\arguments{
\item{all_shots_pl}{Shooting data frame associated with the filters given 
to \code{\link{do_shots_stats}} for the player of interest.}

\item{summary_shots_zone_pl}{Summary of the player's shots by zone.}

\item{summary_shots_zone_league}{Summary of the league's shots by zone.}
}
\value{
A list with the following three elements:
\itemize{
\item all_shots_comp_data: Summary of the shooting data of the player and of the league.
\item all_shots_comp_viz: Summary of the shooting data prepared for the visualization.
\item player: Player's name.
}
}
\description{
Prepare the data for the gradient shooting visualizations at a player level.
}
\examples{
\dontrun{
library(dplyr)

df0 <- do_divide_court_zones(acb_shooting_data_2425)

df1 <- do_filter_data(df0, "2024-2025", "", "", "", "", "")

# LEAGUE METRICS:
shots_stats <- do_shots_stats(df1, df0) 

summary_shots_zone_lg <- shots_stats$summary_shots_zone

summary_shots_zone_league <- summary_shots_zone_lg \%>\%
  mutate(pps_league = ifelse(location_color == "2pt", 
                             (2 * count) / total,  
                             (3 * count) / total)) \%>\%
  select(location, perc_league = perc, pps_league)

# PLAYER METRICS:
df1 <- do_filter_data(df0, "2024-2025", "", "", "", "", "D. Ennis")

shots_stats <- do_shots_stats(df1, df0) 

all_shots_pl <- shots_stats$all_shots

summary_shots_zone_pl <- shots_stats$summary_shots_zone

res_grad <- do_prepare_data_gradient(all_shots_pl, summary_shots_zone_pl, summary_shots_zone_league)
}

}
\seealso{
\code{\link{do_divide_court_zones}}, \code{\link{do_shots_stats}}
}
\author{
Guillermo Vinue
}
