% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_beam_data.R
\name{prep_beam_data}
\alias{prep_beam_data}
\title{Prepare data for BEAM analysis}
\usage{
prep_beam_data(
  main.data,
  mtx.data,
  mtx.anns = NULL,
  set.data = NULL,
  set.anns = NULL,
  n.boot = 1000,
  seed = NULL
)
}
\arguments{
\item{main.data}{A data.frame}

\item{mtx.data}{A list, each element is a matrix}

\item{mtx.anns}{A list, each element is a data.frame}

\item{set.data}{A data.frame with columns set.id, mtx.id, row.id}

\item{set.anns}{A data frame with set.id and other columns}

\item{n.boot}{Number of bootstraps}

\item{seed}{Initial seed for random number generation}
}
\value{
A beam.data object, which is a list with main.data, mtx.data, mtx.anns, anns.mtch, set.data, set.anns, and boot.index
}
\description{
Prepare data for BEAM analysis
}
\examples{
data(clinf)
data(omicdat)
data(omicann)
data(setdat)
test.beam.data <- prep_beam_data(main.data=clinf, mtx.data=omicdat,
                                 mtx.anns=omicann, set.data=setdat,
                                 set.anns=NULL, n.boot=10, seed=123)
}
