\name{BETs}
\alias{BETs}
\title{Binary Expansion Testing up to a Certain Depth}
\usage{
BETs(X, d.max = 4)
}
\arguments{
\item{X}{a matrix to be tested. When \code{X} has only one column, \code{BETs} will test whether \code{X} is [0, 1]-uniformly distributed (an error will be given if data is out of range [0, 1]). When \code{X} has two or more columns, \code{BETs} tests the independence among those column vectors.}

\item{d.max}{the maximal depth of the binary expansion for \code{BETs}.}
}
\value{
\item{bet.s.pvalue}{the overall p-value on the test.}
\item{bet.s.index}{the interaction that the p-value is minimal.}
\item{bet.s.zstatistic}{normal approximation of the test statistic.}
}
\description{
\code{BETs} is used for nonparametric dependence detection.
Extended from \code{BET}, for a chosen maximal depth \code{d.max}, \code{BETs} does a sequential test up to \code{d.max} and avoids overlapping symmetry statistics in different depths,
for all \eqn{2 \le d \le d.max}. The adjustment is done by multiplying the number of interactions which are in the \eqn{\sigma}-field generated by marginal binary expansions at depth \eqn{d} but not in that at depth \eqn{d-1}.
}
\examples{
v <- runif(128, -pi, pi)
X1 <- cos(v) + 2.5 * rnorm(128, 0, 1/20)
X2 <- sin(v) + 2.5 * rnorm(128, 0, 1/20)
BETs(cbind(X1, X2))
}

