% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BETSsearch.R
\name{BETSsearch}
\alias{BETSsearch}
\title{Search for a Brazilian Economic Time Series}
\usage{
BETSsearch(description = "*", src, periodicity, unit, code, start,
  view = TRUE, lang = "en")
}
\arguments{
\item{description}{A \code{character}. A search string to look for matching series descriptions. Check the syntax rules under the 'Details' section for better performance.}

\item{src}{A \code{character}. The source of the series. See the 'Details' section for a list of the available sources.}

\item{periodicity}{A \code{character}. The periodicity of the series. See the 'Details' section for a list of possible values.}

\item{unit}{A \code{character}. The unit of measurement of the data. See the 'Details' section for a list of possible values.}

\item{code}{An \code{integer}. The index of the series within the database.}

\item{start}{A \code{date}. Starting date of the series.}

\item{view}{A \code{boolean}. The default is \code{TRUE}. If set to \code{FALSE}, the output's \code{head} will be printed in your console as a \code{data.frame}.}

\item{lang}{A \code{character}. The search language. The default is "en" for english, but "pt" for portuguese is also possible.}
}
\value{
A \code{list} that can be interpreted as a \code{data.frame}. The fields are described below.

\tabular{ll}{
 code \tab The code/index of the series within the database \cr
 description \tab The description of the series \cr
 periodicity \tab The periodicity of the series \cr
 start \tab Starting date of the series \cr
 source \tab The source of the series \cr
 unit \tab The unit of measurement of the data
}
}
\description{
Searches the BETS databases for a time series by its description, source, periodicity, code, data, unit of measurement and database name.
}
\details{
\itemize{

\item{ Syntax rules for the parameter \code{description}, the search string to look for matching series descriptions: 
   \enumerate{
       \item{To search for alternative words, separate them by white spaces. 
             Example: \code{description = "ipca core"} means that the series description must contain 'ipca' AND'core'
       }
       \item{To search for whole expressions, surround them with \code{' '}.
             Example: \code{description = "'core ipca' index"} means that the series description must contain 'core ipca' AND 'index'
       }
       \item{To exclude words from the search, insert a \code{~} before each of them.
             Example: \code{description = "ipca ~ core"} means that the series description must contain 'ipca' AND must NOT contain 'core'
       }
       \item{To exclude whole expressions from the search, surround them with code{' '} and insert a \code{~} before each of them.
             Example: \code{description = "~ 'ipca core' index"} means that the series description must contain 'index' AND must NOT contain 'core ipca'
       }
       \item{It is possible to search for multiple words or expressions and to negate multiple words or expressions, as long as the preceeding rules are observed. 
       }
       \item{The white space after the negation sign (\code{~}) is not required. But the white spaces AFTER expressions or words ARE required.
       }
     }
   }

\item{ Possible values for the parameter \code{src}:
   \tabular{ll}{
     IBGE \tab Brazilian Institute of Geography and Statistics \cr
     BCB \tab Central Bank of Brazil \cr
     FGV \tab Getulio Vargas Foundation \cr
     FGv-IBRE \tab Getulio Vargas Foundation - Brazilian Institute of Economics \cr
     BCB e FGV \tab Central Bank of Brazil and Getulio Vargas Foundation \cr
     BCB-Deban \tab Cetral Bank of Brazil - Department of Banking and Payments \cr
     BCB-Depin \tab Central Bank of Brazil - Department of International Reserves \cr
     BCB-Derin \tab Central Bank of Brazil - Department of International Affairs \cr
     BCB-Desig \tab Central Bank of Brazil - Department of Financial Monitoring \cr
     BCB-Secre \tab Central Bank of Brazil - Executive Secretariat \cr
     BCB-Demab \tab Central Bank of Brazil - Department of Open Market Operations \cr
     BCB-Denor \tab Central Bank of Brazil - Department of Financial System Regulation \cr
     BCB-Depec \tab Central Bank of Brazil - Department of Economics \cr
     Sisbacen \tab Central Bank of Brazil Information System \cr
     Abecip \tab Brazilian Association of Real Estate Loans and Savings Companies
   }
}

\item{ Possible values for the parameter \code{periodicity}:
   \tabular{ll}{
     A \tab anual data    \cr
     M \tab monthly data  \cr
     Q \tab quaterly data \cr
     W \tab weekly data   \cr
     D \tab daily data 
   }
}

\item{ Possible values for the parameter \code{unit}:
   \tabular{ll}{
     R$ \tab brazilian reais \cr
     $ \tab US dolars        \cr
    \% \tab percentage 
   }
}
}
}
\examples{
#not run
#BETSsearch(description="sales",view = FALSE)


#BETSsearch(src="Denor", view = FALSE)


#BETSsearch(periodicity="A", view = FALSE)


}
\references{
Central Bank of Brazil
}
\keyword{search}
