% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_adjacency.R
\name{plot_adjacency}
\alias{plot_adjacency}
\title{Plot Adjacency Matrix}
\usage{
plot_adjacency(
  x,
  layout = "circle",
  node_labels = NULL,
  node_labels_color = "black",
  node_groups = NULL,
  node_outer_size = 12,
  node_inner_size = 11,
  alpha = 0.5,
  txt_size = 8,
  ...
)
}
\arguments{
\item{x}{adjacency matrix}

\item{layout}{network layout (\link[sna]{gplot.layout})}

\item{node_labels}{node labels}

\item{node_labels_color}{node labels color}

\item{node_groups}{node group indicator}

\item{node_outer_size}{node border size}

\item{node_inner_size}{node size}

\item{alpha}{edge transparency}

\item{txt_size}{node text size}

\item{...}{additional arguments (\link[GGally]{ggnet2})}
}
\value{
object of class \code{ggplot}
}
\description{
Plot Adjacency Matrix
}
\examples{
\donttest{
# data
Y <- rsa[,-ncol(rsa)]

# fit model
fit_explore <- explore(Y, iter = 1000)

# select the graph (edge set E)
E <- select(fit_explore)

plot_adjacency(E$Adj_10, node_groups = BGGM:::rsa_labels)
}
}
