% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_estimate.R
\name{summary.var_estimate}
\alias{summary.var_estimate}
\title{Summary Method for \code{var_estimate} Objects}
\usage{
\method{summary}{var_estimate}(object, cred = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{var_estimate}}

\item{cred}{Numeric. The credible interval width for summarizing the posterior
distributions (defaults to 0.95; must be between 0 and 1).}

\item{...}{Currently ignored.}
}
\value{
A dataframe containing the summarized posterior distributions,
including both the partial correlations and the regression coefficients.

\itemize{

\item \code{pcor_results} A data frame including the summarized partial correlations

\item \code{beta_results} A list containing the summarized regression coefficients (one
data frame for each outcome)
}
}
\description{
Summarize the posterior distribution of each partial correlation
and regression coefficient with the posterior mean, standard deviation, and
credible intervals.
}
\examples{
\donttest{
# data
Y <- subset(ifit, id == 1)[,-1]

# fit model with alias (var_estimate also works)
fit <- var_estimate(Y, progress = FALSE)

# summary ('pcor')
print(
summary(fit, cred = 0.95),
param = "pcor",
)


# summary ('beta')
print(
summary(fit, cred = 0.95),
param = "beta",
)

}
}
\seealso{
\code{\link{var_estimate}}
}
