% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentPedigree.R
\name{ped2maternal}
\alias{ped2maternal}
\title{Add a maternal line ID variable to a pedigree}
\usage{
ped2maternal(
  ped,
  personID = "ID",
  momID = "momID",
  dadID = "dadID",
  matID = "matID",
  ...
)
}
\arguments{
\item{ped}{a pedigree dataset.  Needs ID, momID, and dadID columns}

\item{personID}{character.  Name of the column in ped for the person ID variable}

\item{momID}{character.  Name of the column in ped for the mother ID variable}

\item{dadID}{character.  Name of the column in ped for the father ID variable}

\item{matID}{Character. Maternal line ID variable to be created and added to the pedigree}

\item{...}{additional arguments to be passed to \code{\link{ped2com}}}
}
\description{
Add a maternal line ID variable to a pedigree
}
\details{
Under various scenarios it is useful to know which people in a pedigree
belong to the same maternal lines.  This function first turns a pedigree
into a graph where adjacency is defined by mother-child relationships.
Subsequently, the weakly connected components algorithm finds all the
separate maternal lines and gives them an ID variable.
}
\seealso{
[ped2fam()] for creating extended family IDs, and [ped2paternal()]
for creating paternal line IDs
}
