% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizePedigree.R
\name{summarizePedigrees}
\alias{summarizePedigrees}
\alias{summarisePedigrees}
\title{Summarize Pedigree Data}
\usage{
summarizePedigrees(
  ped,
  famID = "famID",
  personID = "ID",
  momID = "momID",
  dadID = "dadID",
  matID = "matID",
  patID = "patID",
  type = c("fathers", "mothers", "families"),
  byr = NULL,
  include_founder = FALSE,
  founder_sort_var = NULL,
  nbiggest = 5,
  noldest = nbiggest,
  skip_var = NULL,
  five_num_summary = FALSE,
  network_checks = FALSE,
  verbose = FALSE
)

summarisePedigrees(
  ped,
  famID = "famID",
  personID = "ID",
  momID = "momID",
  dadID = "dadID",
  matID = "matID",
  patID = "patID",
  type = c("fathers", "mothers", "families"),
  byr = NULL,
  include_founder = FALSE,
  founder_sort_var = NULL,
  nbiggest = 5,
  noldest = nbiggest,
  skip_var = NULL,
  five_num_summary = FALSE,
  network_checks = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{ped}{a pedigree dataset.  Needs ID, momID, and dadID columns}

\item{famID}{character.  Name of the column to be created in ped for the family ID variable}

\item{personID}{character.  Name of the column in ped for the person ID variable}

\item{momID}{character.  Name of the column in ped for the mother ID variable}

\item{dadID}{character.  Name of the column in ped for the father ID variable}

\item{matID}{Character. Maternal line ID variable to be created and added to the pedigree}

\item{patID}{Character.  Paternal line ID variable to be created and added to the pedigree}

\item{type}{Character vector. Specifies which summaries to compute.
Options: `"fathers"`, `"mothers"`, `"families"`. Default includes all three.}

\item{byr}{Character. Optional column name for birth year. Used to determine the oldest lineages.}

\item{include_founder}{Logical. If `TRUE`, includes the founder (originating member) of each lineage in the output.}

\item{founder_sort_var}{Character. Column used to determine the founder of each lineage.
Defaults to `byr` (if available) or `personID` otherwise.}

\item{nbiggest}{Integer. Number of largest lineages to return (sorted by count).}

\item{noldest}{Integer. Number of oldest lineages to return (sorted by birth year).}

\item{skip_var}{Character vector. Variables to exclude from summary calculations.}

\item{five_num_summary}{Logical. If `TRUE`, includes the first quartile (Q1) and third quartile (Q3) in addition to
the minimum, median, and maximum values.}

\item{network_checks}{Logical. If `TRUE`, performs network checks on the pedigree data.}

\item{verbose}{Logical, if TRUE, print progress messages.}
}
\value{
A data.frame (or list) containing summary statistics for family, maternal, and paternal lines, as well as the 5 oldest and biggest lines.
}
\description{
This function summarizes pedigree data, by
computing key summary statistics for all numeric variables and identifying the
originating member (founder) for each family, maternal, and paternal lineage.
}
\details{
The function calculates standard descriptive statistics, including the count of individuals in
each lineage, means, medians, minimum and maximum values, and standard deviations.
Additionally, if `five_num_summary = TRUE`, the function includes the first and third quartiles (Q1, Q3)
to provide a more detailed distributional summary. Users can also specify variables to exclude from
the analysis via `skip_var`.

Beyond summary statistics, the function identifies the founding member of each lineage
based on the specified sorting variable (`founder_sort_var`), defaulting to birth year (`byr`)
when available or `personID` otherwise. Users can retrieve the largest and oldest
lineages by setting `nbiggest` and `noldest`, respectively.
}
