% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposeIgnorance.R
\name{exposeIgnorance}
\alias{exposeIgnorance}
\title{Create ignorance scores}
\usage{
exposeIgnorance(nObs, nSpp = NULL, h = 1)
}
\arguments{
\item{nObs}{an object of any class (mainly resulting from \code{summariseBirds} or
\code{exportBirds} with  the number of observations, or visits in your desired analysis unit.}

\item{nSpp}{the number of unique species observed}

\item{h}{the half ignorance parameter value.}
}
\value{
a \code{data.frame} with ignorance scores
}
\description{
Ignorance scores are a proxy for the lack of sampling effort, computed by making
the number of observations relative to a reference number of observations that
is considered to be enough to reduce the ignorance score by half (henceforth
the Half-ignorance approach). The algorithm behind the Ignorance Score is
designed for comparison of bias and gaps in primary biodiversity data across
taxonomy, time and space
}
\examples{
\donttest{
OB <- organizeBirds(bombusObsShort, sppCol = "scientificName", simplifySppName = TRUE)
grid <- makeGrid(searchPolygon, gridSize = 10)
SB <- summariseBirds(OB, grid=grid)
ignorance <- exposeIgnorance(nObs=SB$spatial@data$nObs)
}
}
\references{
Ruete (2015) <doi:10.3897/BDJ.3.e5361>
}
\seealso{
\code{\link{summarizeBirds}}, \code{\link{exportBirds}}
}
