% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMisc.R
\name{subsample}
\alias{subsample}
\title{subsample}
\usage{
subsample(dta, idname, tname, keepids = NULL, nkeep = NULL)
}
\arguments{
\item{dta}{a data.frame which is a balanced panel}

\item{idname}{the name of the id variable}

\item{tname}{the name of the time variable}

\item{keepids}{which ids to keep}

\item{nkeep}{how many ids to keep (only used if \code{keepids}
is not set); the default is the number of unique ids}
}
\value{
a data.frame that contains a subsample of \code{dta}
}
\description{
returns a subsample of a panel data set; in particular drops
 all observations that are not in \code{keepids}.  If it is not set,
 randomly keeps \code{nkeep} observations.
}
\examples{
data(LaborSupply, package="plm")
nrow(LaborSupply)
unique(LaborSupply$year)
ss <- subsample(LaborSupply, "id", "year", nkeep=100)
nrow(ss)

}
