% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_functions.R
\name{mvnorm_sd}
\alias{mvnorm_sd}
\title{Draw a sample from a multivariate normal distribution}
\usage{
mvnorm_sd(mu, decomp.covariance)
}
\arguments{
\item{mu}{The mean vector}

\item{decomp.covariance}{This spectral decomposition part of the sampler. It is V\emph{U^0.5, where Sigma = V}U*t(V). The required component is returned by the construct_constrained_covariance_matrix function.}
}
\value{
a vector containing a sample from the distribution
}
\description{
This draws a sample from a multivariate normal distribution with mean vector mu and covariance matrix Sigma. It requires the covariance matrix to be decomposed using spectral decomposition (eigen).
}
\examples{

mu <- c(2, 1) #mean vector
sigma <- matrix(c(2^2, 0.5*2*1, 0.5*2*1, 1^2), 2, 2) #covariacne matrix
sigma.eigen <- eigen(sigma)
decomp.covariance <- sigma.eigen$vectors\%*\%diag(sqrt(sigma.eigen$values))
f <- mvnorm_sd(mu, decomp.covariance) #draw sample

}
\keyword{distribution}
\keyword{internal}
