\name{sign.test}
\alias{sign.test}

\title{Sign Test}
\description{
This function will test a hypothesis based on the sign test and reports 
linearly interpolated confidence intervals for one sample problems. 
}
\usage{
sign.test(x, y = NULL, md = 0, alternative = "two.sided", conf.level = 0.95)
}

\arguments{
  \item{x}{numeric vector. \code{NA}s and \code{Inf}s are allowed but will be removed.}
  \item{y}{optional numeric vector. \code{NA}s and \code{Inf}s are allowed but will be removed.}
  \item{md}{a single number representing the value of the population median specified
  by the null hypothesis. }
  \item{alternative}{character string, one of \code{"greater"}, \code{"less"} or 
  \code{"two.sided"}, or just the initial letter of each, indicating the specification 
  of the alternative hypothesis. For one-sample tests, alternative refers to the true 
  median of the parent population in relation to the hypothesized value median.}
  \item{conf.level}{confidence level for the returned confidence interval, restricted 
  to lie between zero and one.}
}
\details{Computes a "Dependent-samples Sign-Test" if both \code{x} and \code{y} are provided.  
If only \code{x} is provided,  computes the "Sign-Test".
}
\value{A list of class \code{"htest"}, containing the following components: 
  \item{statistic}{the S-statistic (the number of positive differences between 
  the data and the hypothesized median), with names attribute "S" .}
  \item{p.value}{the p-value for the test.}
  \item{conf.int}{a confidence interval (vector of length 2) for the true 
  median based on linear interpolation. The confidence level is recorded in 
  the attribute \code{conf.level}. When alternative is not \code{"two.sided"}, 
  the confidence interval will be half-infinite, to reflect the interpretation 
  of a confidence interval as the set of all values \code{k} for which one would 
  not reject the null hypothesis that the true mean or difference in means is \code{k}. 
  Here infinity will be represented by \code{Inf}.}
  \item{estimate}{vector of length 1, giving the sample median; this estimates the 
  corresponding population parameter. Component estimate has a names attribute 
  describing its elements.}
  \item{null.value}{the value of the median specified by the null hypothesis. This 
  equals the input argument \code{md}. Component \code{null.value} has a names 
  attribute describing its elements.}
  \item{alternative}{records the value of the input argument alternative: 
  \code{"greater"}, \code{"less"} or \code{"two.sided"}.}
  \item{data.name}{a character string (vector of length 1) containing the actual 
  name of the input vector \code{x}.}
}

\section{Null Hypothesis}{For the one-sample sign-test, the null hypothesis is 
that the median of the population from which \code{x} is drawn is \code{md}. 
For the two-sample dependent case, the null hypothesis is 
that the median for the differences of the populations from which \code{x}
and \code{y} are drawn is \code{md}. 
The alternative hypothesis indicates the direction of divergence of the 
population median for \code{x} from \code{md} (i.e., \code{"greater"}, \code{"less"}, 
\code{"two.sided"}.}}

\section{Assumptions}{The median test assumes the parent population is continuous.} 
 \section{Confidence Interval}{A linear interpolation is returned for the related 
 confidence interval (returned component \code{conf.int}) which can be obtained by 
 interpolating between the possible achieved confidence levels closest to the 
 desired level. Note however that, as explained under the description of 
 \code{conf.int}, the confidence interval will be half-infinite when alternative 
 is not \code{"two.sided"}; infinity will be represented by \code{Inf}.}

\references{
Gibbons, J.D. and Chakraborti, S. (1992). 
\emph{Nonparametric Statistical Inference}. Marcel Dekker Inc., New York. 

Kitchens, L.J.(2003). \emph{Basic Statistics and Data Analysis}. Duxbury. 

Conover, W. J. (1980). \emph{Practical Nonparametric Statistics, 2nd ed}. Wiley, New York. 

Lehmann, E. L. (1975). \emph{Nonparametrics: Statistical Methods Based on Ranks}. Holden and Day, San Francisco.
}

\author{Alan T. Arnholt}

\note{The reported confidence interval in \code{$rval$} is based on a 
linear interpolation. The lower and upper confidence levels in 
\code{$confidence.intervals$} are exact.}

\seealso{\code{\link{z.test}}, \code{\link{zsum.test}}, \code{\link{tsum.test}}}
\examples{
x <- c(7.8, 6.6, 6.5, 7.4, 7.3, 7., 6.4, 7.1, 6.7, 7.6, 6.8)
sign.test(x,md=6.5)
        # Computes two-sided sign-test for the null hypothesis 
        # that the population median for 'x' is 6.5. The alternative 
        # hypothesis is that the median is not 6.5. An interpolated 95% 
        # confidence interval for the population median will be computed.
        
reaction <- c(14.3, 13.7, 15.4, 14.7, 12.4, 13.1, 9.2, 14.2, 
              14.4, 15.8, 11.3, 15.0)
sign.test(reaction, md=15, alternative="less")
        # Data from Example 6.11 page 330 of Kitchens BSDA.  
        # Computes one-sided sign-test for the null hypothesis 
        # that the population median is 15.  The alternative 
        # hypothesis is that the median is less than 15.  
        # An interpolated upper 95% upper bound for the population 
        # median will be computed.
}
\keyword{htest}
