% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Ligntmonth}
\alias{Ligntmonth}
\title{Relationship between damage reports and deaths caused by lightning}
\format{A data frame/tibble with 12 observations on four variables
\describe{ 
\item{month}{a factor with levels \code{1/01/2000},
\code{10/01/2000}, \code{11/01/2000}, \code{12/01/2000}, \code{2/01/2000},
\code{3/01/2000}, \code{4/01/2000}, \code{5/01/2000}, \code{6/01/2000},
\code{7/01/2000}, \code{8/01/2000}, and \code{9/01/2000}} 
\item{deaths}{number of deaths due to lightning strikes} 
\item{injuries}{number of injuries due to lightning strikes}
\item{damage}{damage due to lightning strikes (in dollars)} 
}}
\source{
\emph{Lighting Fatalities, Injuries and Damage Reports in the United States},
1959-1994, NOAA Technical Memorandum NWS SR-193, Dept. of Commerce.
}
\usage{
Ligntmonth
}
\description{
Data for Exercise 2.6
}
\examples{

plot(deaths ~ damage, data = Ligntmonth)
model = lm(deaths ~ damage, data = Ligntmonth)
abline(model, col = "red")
rm(model)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
