% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectPenalty.R
\name{selectPenalty}
\alias{selectPenalty}
\title{Selecting the Penalty Parameter}
\usage{
selectPenalty(
  ssy,
  n,
  lambda,
  M,
  sigma = 1.5,
  model,
  theta = NULL,
  method = c("BSL", "semiBSL"),
  shrinkage = c("glasso", "Warton"),
  parallelSim = FALSE,
  parallelSimArgs = NULL,
  parallelMain = FALSE,
  verbose = 1L,
  ...
)
}
\arguments{
\item{ssy}{A summary statistic vector for the observed
data.}

\item{n}{A vector of possible values of \code{n}, the
number of simulations from the model per MCMC iteration for estimating the
synthetic likelihood.}

\item{lambda}{A list, with each entry containing the vector of
penalty values to test for the corresponding choice of \code{n}.}

\item{M}{The number of repeats to use in estimating the
standard deviation of the estimated log synthetic likelihood.}

\item{sigma}{The standard deviation of the log synthetic
likelihood estimator to aim for, usually a value between 1 and 2. This
parameter helps to control the mixing of a Markov chain.}

\item{model}{A ``MODEL'' object generated with function
\code{newModel}. See \code{\link{newModel}}.}

\item{theta}{A point estimate of the parameter value which
all of the simulations will be based on. By default, if \code{theta} is
\code{NULL}, it will be replaced by \code{theta0} from the given
\code{model}.}

\item{method}{A string argument indicating the method to be
used. If the method is ``BSL'', the shrinkage is applied to the Gaussian
covariance matrix. Otherwise if the method is ``semiBSL'', the shrinkage is
applied to the correlation matrix of the Gaussian copula.}

\item{shrinkage}{A string argument indicating which shrinkage method to
be used. Current options are ``glasso'' for the graphical lasso method of
\insertCite{Friedman2008;textual}{BSL} and ``Warton'' for the ridge
regularisation method of \insertCite{Warton2008;textual}{BSL}.}

\item{parallelSim}{A logical value indicating whether parallel
computing should be used for simulation and summary statistic evaluation.
Default is \code{FALSE}.}

\item{parallelSimArgs}{A list of additional arguments to pass into the
\code{foreach} function. Only used when \code{parallelSim} is \code{TRUE},
default is \code{NULL}.}

\item{parallelMain}{A logical value indicating whether parallel
computing should be used to computing the graphical lasso function. Notice
that this should only be turned on when there are a lot of candidate values
in \code{lambda}. Default is \code{FALSE}.}

\item{verbose}{An integer indicating the verbose style. 0L
means no verbose messages will be printed. 1L uses a custom progress bar to
track the progress. 2L prints the iteration numbers (\code{1:M}) to track
the progress. The default is 1L.}

\item{...}{Other arguments to pass to \code{\link{gaussianSynLike}} (``BSL''
method) or \code{\link{semiparaKernelEstimate}} (``semiBSL'' method).}
}
\value{
An S4 object \code{PENALTY} of the penalty selection results. The
  \code{show} and \code{plot} methods are provided with the S4 class.
}
\description{
This is the main function for selecting the shrinkage (graphical
  lasso or Warton's estimator) penalty parameter for method BSL or semiBSL
  based on a point estimate of the parameters. Parallel computing is
  supported with the R package \code{foreach}. The penalty selection method
  is outlined in \insertCite{An2019;textual}{BSL}.
}
\examples{
\dontrun{
data(ma2)
model <- newModel(fnSimVec = ma2_sim_vec, fnSum = ma2_sum, simArgs = ma2$sim_args,
                  theta0 = ma2$start, fnLogPrior = ma2_prior)
theta <- c(0.6,0.2)

# Performing tuning for BSLasso (BSL with glasso shrinkage estimation)
ssy <- ma2_sum(ma2$data)
lambda_all <- list(exp(seq(-3,0.5,length.out=20)), exp(seq(-4,-0.5,length.out=20)),
                   exp(seq(-5.5,-1.5,length.out=20)), exp(seq(-7,-2,length.out=20)))
set.seed(100)
sp_ma2 <- selectPenalty(ssy = ssy, n = c(50, 150, 300, 500), lambda_all, theta = theta,
    M = 100, sigma = 1.5, model = model, method = 'BSL', shrinkage = 'glasso')
sp_ma2
plot(sp_ma2)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{PENALTY} for the usage of the S4 class. \code{\link{ma2}},
  \code{\link{cell}} and \code{\link{mgnk}} for examples. \code{\link{bsl}}
  for the main function to run BSL.
}
\author{
Ziwen An, Leah F. South and Christopher Drovandi
}
