% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lower_bnd_CP.R
\name{lower_bnd_CP}
\alias{lower_bnd_CP}
\title{Calculate the lower bound of the log likelihood for a trained CP model}
\usage{
lower_bnd_CP(m, d)
}
\arguments{
\item{m}{object of the class \code{CP_model}}

\item{d}{object of the class \code{input_data}}
}
\value{
Returns a numerical value (should be negative)
}
\description{
Calculate the lower bound of the log likelihood for a trained CP model
}
\examples{
data.params <- get_data_params(c('decomp=CP'))
toy <- mk_toy(data.params)
train.data <- input_data$new(mode1.X=toy$mode1.X[,-1],
                             mode2.X=toy$mode2.X[,-1],
                             mode3.X=toy$mode3.X[,-1],
                             resp=toy$resp)
model.params <- get_model_params(c('decomp=CP'))
toy.model <- mk_model(train.data, model.params)
toy.model$rand_init(model.params)

train(d=train.data, m=toy.model, new.iter=1, params=model.params)

lower_bnd_CP(toy.model, train.data)
}

