% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/complement.R
\name{complement_element}
\alias{complement_element}
\alias{complement_element,TidySet,characterORfactor-method}
\title{Complement of elements}
\usage{
complement_element(object, elements, ...)

\S4method{complement_element}{TidySet,characterORfactor}(
  object,
  elements,
  name = NULL,
  FUN = NULL,
  keep = TRUE,
  keep_relations = keep,
  keep_elements = keep,
  keep_sets = keep
)
}
\arguments{
\item{object}{A TidySet object.}

\item{elements}{The set to look for the complement.}

\item{...}{Placeholder for other arguments that could be passed to the
method. Currently not used.}

\item{name}{Name of the new set. By default it adds a "C".}

\item{FUN}{A function to be applied when performing the union.
The standard union is the "max" function, but you can provide any other
function that given a numeric vector returns a single number.}

\item{keep}{Logical value to keep all the other sets.}

\item{keep_relations}{A logical value if you wan to keep old relations.}

\item{keep_elements}{A logical value if you wan to keep old elements.}

\item{keep_sets}{A logical value if you wan to keep old sets.}
}
\value{
A \code{TidySet} object.
}
\description{
Return the objects without the elements listed
}
\section{Methods (by class)}{
\itemize{
\item \code{object = TidySet,elements = characterORfactor}: Complement of the elements.
}}

\examples{
relations <- data.frame(
    sets = c("A", "A", "B", "B", "C", "C"),
    elements = letters[seq_len(6)],
    fuzzy = runif(6)
)
TS <- tidySet(relations)
complement_element(TS, "a", "C_a")
complement_element(TS, "a", "C_a", keep = FALSE)
}
\seealso{
Other complements: 
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{subtract}()}

Other methods that create new sets: 
\code{\link{complement_set}()},
\code{\link{intersection}()},
\code{\link{subtract}()},
\code{\link{union}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_column}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{complements}
\concept{methods}
\concept{methods that create new sets}
