% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ripple.ord.R
\name{ripple.ord}
\alias{ripple.ord}
\title{Update linkage map with alternative orders at all positions}
\usage{
ripple.ord(input.seq, ws = 4, tol = 0.001, phase.cores = 1,
  ripple.cores = 1, method = "one", n = NULL, pref = "neutral",
  start = 1, verbosity = NULL, batches = NULL, no_reverse = TRUE,
  optimize = "likelihood")
}
\arguments{
\item{input.seq}{An object of class \code{sequence}.}

\item{ws}{The window size in which ti consider re-ordering}

\item{tol}{The tolerance for checking convergence of the EM model}

\item{phase.cores}{The number of parallel processes to use to estimate phases.
Should be no higher than 4.}

\item{ripple.cores}{The number of parallel processes that should be used when
testing different marker orders.}

\item{method}{One of "one", "all" or "rand". Which algorithm to use to
generate alternative orders to test (see Details)}

\item{n}{For method "rand": The number of random samples to be tested.}

\item{pref}{For method "rand": One of "similar", "dissimilar" or "neutral".
Controls if sampling probability should be adjusted based on similarity to
the input sequence. See description.}

\item{start}{The position of the first marker of the window within the
input sequence}

\item{verbosity}{A character vector that includes any or all of "batch",
"order", "position", "time" and "phase" to output progress status
information.}

\item{batches}{List with batches that are being processed. Only used when
estimating finish time.}

\item{no_reverse}{For method "one": If \code{FALSE}, the method will also
create all possible reverse sequences if the marker swaps.}

\item{optimize}{Either "likelihood" or "count". Passed to \code{ripple.ord}
in order to optimize the map's likelihood or the RECORD COUNT criterion.
Unless you are absolutely sure why, you should use "likelihood".}
}
\value{
An object of class \code{sequence} that is the best order for the
re-ordered input sequence.
}
\description{
This function carries out re-ordering of all markers using a sliding window
according to user defined criteria. The best order is chosen based on the
difference in log likelihood. Different heuristics are avaible to select
which orders to test. Note that testing all orders has factorial complexity
(N!/2) meaning that it's not feasible for window sizes larger than 6.
}
\details{
Methods:
\emph{all:}{Checks for all possible permutations in the window. Will be very
very slow for large window size.}
\emph{one:}{Checks for all possible pairwise switches in the window. The
complexity scales as \code{sum(ws:1)}, \code{ws} being the window size.}
\emph{rand:}{First, generates all possible permutations. Then samples
\code{n} sequences from those and tests those. Time complexity is N.}
The "rand" method can be further tuned to preferentially select similar,
dissimilar sequences or to perform unbiased sampling. In the first two cases
sampling probability is adjusted via a spearman correlation of the sequences
to all possible sequences.
}
