#' Meta-analysis data with full compliance information
#'
#' The data contains a meta analysis of the association between using epidural
#' analgesia in labor and the risk of cesarean section. It contains 10 trials
#' with full compliance information, each with 8 observed counts.
#'
#' @docType data
#'
#' @usage data(epidural_c)
#'
#' @keywords dataset
#'
#' @references Bannister-Tyrrell M, Miladinovic B, Roberts CL, Ford JB. 
#' Adjustment for compliance behavior in trials of epidural analgesia in labor using instrumental variable meta-analysis. 
#' J Clin Epidemiol. 2015 May;68(5):525-33. doi: 10.1016/j.jclinepi.2014.11.005. Epub 2014 Dec 18. PMID: 25592169.
#'
#' @source \url{https://pubmed.ncbi.nlm.nih.gov/25592169/}
#' @examples
#' data(epidural_c)
"epidural_c"