% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_ermod.R
\name{sim_er}
\alias{sim_er}
\title{Simulate from ER model}
\usage{
sim_er(
  ermod,
  newdata = NULL,
  n_draws_sim = NULL,
  seed_sample_draws = NULL,
  output_type = c("draws", "median_qi"),
  qi_width = 0.95,
  .nrow_cov_data = NULL
)
}
\arguments{
\item{ermod}{An object of class \code{ermod}}

\item{newdata}{New data to use for simulation.
Default is NULL (use the data in the model object).}

\item{n_draws_sim}{Number of draws for simulation. If NULL (default),
all draws in the model object are used.}

\item{seed_sample_draws}{Seed for sampling draws. Default is NULL.}

\item{output_type}{Type of output. "draws" returns the raw draws from the
simulation, and "median_qi" returns the median and quantile interval.}

\item{qi_width}{Width of the quantile interval. Default is 0.95. Only
used when \code{output_type = "median_qi"}.}

\item{.nrow_cov_data}{Number of rows in the covariate data,
used for internal purposes. Users should not set this argument.}
}
\value{
\code{ersim} object, which is a tibble with the simulated responses
with some additional information in object attributes.
It has three types of predictions - \code{.linpred}, \code{.epred}, \code{.prediction}.
\code{.linpred} and \code{.epred} are similar in a way that they both represent
"expected response", i.e. without residual variability. They are the same
for models with continuous endpoits (Emax model). For models with binary
endpoints, \code{.linpred} is the linear predictor (i.e. on the logit scale) and
\code{.epred} is on the probability scale. \code{.prediction} is the predicted
response with residual variability (or in case of binary endpoint,
the predicted yes (1) or no (0) for event occurrence).
See \code{\link[tidybayes:add_predicted_draws]{tidybayes::add_epred_draws()}} for more details.

In case of \code{output_type = "median_qi"}, it returns \code{ersim_med_qi} object.
}
\description{
Simulate from ER model
}
\examples{
\donttest{
data(d_sim_binom_cov_hgly2)

ermod_bin <- dev_ermod_bin(
  data = d_sim_binom_cov_hgly2,
  var_resp = "AEFLAG",
  var_exposure = "AUCss_1000",
  var_cov = "BHBA1C_5",
)

ersim <- sim_er(
  ermod_bin,
  n_draws_sim = 500, # This is set to make the example run faster
  output_type = "draws"
)

ersim_med_qi <- sim_er(
  ermod_bin,
  n_draws_sim = 500, # This is set to make the example run faster
  output_type = "median_qi"
)

ersim
ersim_med_qi
}

}
\seealso{
\code{\link[=calc_ersim_med_qi]{calc_ersim_med_qi()}} for calculating median and quantile interval
from \code{ersim} object (generated with \code{output_type = "draws"}).
}
