% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputs.R
\name{summary.BayesFBHborrow}
\alias{summary.BayesFBHborrow}
\title{Summarize fixed MCMC results}
\usage{
\method{summary}{BayesFBHborrow}(
  object,
  estimator = NULL,
  percentiles = c(0.025, 0.25, 0.75, 0.975),
  ...
)
}
\arguments{
\item{object}{MCMC sample object from BayesFBHborrow()}

\item{estimator}{The type of estimator to summarize, could be "fixed", "lambda",
"lambda_0" or "s". The default is NULL and will print a summary of the output list.}

\item{percentiles}{Given percentiles to output, default is c(0.025, 0.25, 0.75, 0.975)}

\item{...}{other arguments, see summary.default}
}
\value{
summary of the given estimator
}
\description{
S3 method for with borrowing. Returns summary of mean, median and given 
percentiles for the one dimensional parameters.
}
\examples{
data(piecewise_exp_cc, package = "BayesFBHborrow")

# Set your initial values and hyper parameters
s <- c(0, quantile(piecewise_exp_cc$tte, c(0.5, 1.0), names = FALSE))
initial_param <- list("J" = 1, 
                      "s_r" = s[2], # split points only (length J) 
                      "mu" = 0, 
                      "sigma2" = 2,
                      "lambda" = c(1, 1),
                       "beta" = 0)

# run the MCMC sampler CHANGE THIS BEFORE FINAL CHECK
out <- BayesFBHborrow(piecewise_exp_cc, NULL, initial_param,
                iter = 10, warmup_iter = 1)

# Create a summary of the output
summary(out, estimator = "out_fixed")
}
