% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mode-finding.R
\name{opt.Descent}
\alias{opt.Descent}
\title{Standard gradient descent}
\usage{
opt.Descent(eta = 0.1)
}
\arguments{
\item{eta}{stepsize}
}
\value{
list containing
\itemize{
    \item `julivar` - julia variable holding the optimiser
    \item `juliacode` - string representation
}
}
\description{
Standard gradient descent
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  find_mode(bnn, opt.Descent(1e-5), 10, 100)
}

}
