#' Chrysene concentration data
#'
#' Vector of 8 observations of chrysene concentration (ppb) found in water samples.
#'
#' @format Numeric vector.
#' @source USEPA. \emph{Statistical analysis of groundwater monitoring data at rcra facilities: Unifed guidance.}
#'Technical report, Office of Resource Conservation and Recovery, Program Implementation
#'and Information Division, U.S. Environmental Protection Agency, Washington,
#'D.C. (2009).
"EPA09"



#' Naval Construction Battalion Center data
#'
#'Data frame of 17 observations in 2 variables
#'
#'@format Dataframe with 2 variables:
#'
#'\code{al}: aluminium concentration measures.
#'
#'\code{mn}: manganese concentration measures.
#'
#'@source Singh, Ashok K., Anita Singh, and Max Engelhardt. \emph{The lognormal distribution
#'in environmental applications.} Technology Support Center Issue Paper. (1997).
#'

"NCBC"


#' Low cycle fatigue data
#'
#'Data frame of 22 observations in 2 variables
#'
#'@format Dataframe with variables:
#'
#'\code{stress}: stress factor.
#'
#'\code{cycle}: number of test cycles.
#'
#'
#'@source Upadhyay, S. K., and M. Peshwani. \emph{Posterior analysis of lognormal regression models using
#'the Gibbs sampler.} Statistical Papers 49.1 (2008): 59-85.
#'

"fatigue"


#' Laminators
#'
#'Data frame of 39 observations in 2 variables.
#'
#'@format Dataframe with variables:
#'
#'\code{Worker}: label of the measured worker.
#'
#'\code{log_Y}: logarithm of the measured Styrene concentration.
#'
#'
#'@source R. H. Lyles, L. L. Kupper, and S. M. Rappaport. \emph{Assessing regulatory compliance of occupational exposures via the balanced one-way random effects ANOVA model} Journal of Agricultural, Biological, and Environmental Statistics (1997).
#'
"laminators"


#' Reading Times data
#'
#'Data frame of 547 observations in 4 variables
#'
#'@format Dataframe with variables:
#'
#'\code{subj}: label indicating the subject.
#'
#'\code{item}: label indicating the item read.
#'
#'\code{so}: variable assuming value 1 (object relative condition) and -1 (subject relative condition).
#'
#'\code{log_rt}: logarithm of the reading time measured.
#'
#'
#'@source E. Gibson and H.-H. I. Wu. \emph{Processing chinese relative clauses in context.} Language and Cognitive Processes, 28(1-2):125-155. (2008).
#'
"ReadingTime"

