% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_priors.R
\name{set_priors}
\alias{set_priors}
\title{Set prior parameters for Bayesian Mallows model}
\usage{
set_priors(gamma = 1, lambda = 0.001, psi = 10, kappa = c(1, 3))
}
\arguments{
\item{gamma}{Strictly positive numeric value specifying the shape parameter
of the gamma prior distribution of \eqn{\alpha}. Defaults to \code{1}, thus
recovering the exponential prior distribution used by
\insertCite{vitelli2018}{BayesMallows}.}

\item{lambda}{Strictly positive numeric value specifying the rate parameter
of the gamma prior distribution of \eqn{\alpha}. Defaults
to \code{0.001}. When \code{n_cluster > 1}, each mixture component \eqn{\alpha_{c}}
has the same prior distribution.}

\item{psi}{Positive integer specifying the concentration parameter \eqn{\psi}
of the Dirichlet prior distribution used for the cluster probabilities
\eqn{\tau_{1}, \tau_{2}, \dots, \tau_{C}}, where \eqn{C} is the value of
\code{n_clusters}. Defaults to \code{10L}. When \code{n_clusters = 1}, this argument is
not used.}

\item{kappa}{Hyperparameters of the truncated Beta prior used for error
probability \eqn{\theta} in the Bernoulli error model. The prior has the
form \eqn{\pi(\theta) = \theta^{\kappa_{1}} (1 - \theta)^{\kappa_{2}}}.
Defaults to \code{c(1, 3)}, which means that the \eqn{\theta} is a priori
expected to be closer to zero than to 0.5. See
\insertCite{crispino2019}{BayesMallows} for details.}
}
\value{
An object of class \code{"BayesMallowsPriors"}, to be provided in the
\code{priors} argument to \code{\link[=compute_mallows]{compute_mallows()}}, \code{\link[=compute_mallows_mixtures]{compute_mallows_mixtures()}}, or
\code{\link[=update_mallows]{update_mallows()}}.
}
\description{
Set values related to the prior distributions for the Bayesian
Mallows model.
}
\references{
\insertAllCited{}
}
\seealso{
Other preprocessing: 
\code{\link{get_transitive_closure}()},
\code{\link{set_compute_options}()},
\code{\link{set_initial_values}()},
\code{\link{set_model_options}()},
\code{\link{set_smc_options}()},
\code{\link{setup_rank_data}()}
}
\concept{preprocessing}
