% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_blc.R
\name{predict.BLC}
\alias{predict.BLC}
\title{Forecast for fitted BLC models}
\usage{
\method{predict}{BLC}(object, h, ...)
}
\arguments{
\item{object}{A \code{BLC} object that is result of a call to blc() function.}

\item{h}{The prediction horizon.}

\item{...}{Other arguments.}
}
\value{
A \code{PredBLC} object that contains a list with predicted values calculated
from \code{BLC} object chains structured in an array.
}
\description{
Calculates the means and variances of the forecast distributions based on
the resulting chains from an estimation method.
}
\examples{
## Importing log-mortality data from Portugal:
data(PT)
Y <- PT

## Fitting the model
fit = blc(Y = Y, numit = 100, warmup = 20)

## Prediction for 2 years ahead
pred = predict(fit, h = 2)
print(pred)

}
\seealso{
\code{\link[=fitted.BLC]{fitted.BLC()}}, \code{\link[=print.BLC]{print.BLC()}}, and \code{\link[=plot.BLC]{plot.BLC()}} for \code{PredBLC} methods to native R functions \code{\link[=fitted]{fitted()}},
\code{\link[=print]{print()}}, and \code{\link[=plot]{plot()}}.

\code{\link[=expectancy.BLC]{expectancy.BLC()}} and \link{Heatmap.BLC} to compute and plot the life expectancy of the prediction(s).
}
