% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectancy_blc.R
\name{expectancy.BLC}
\alias{expectancy.BLC}
\title{BLC: Life expectancy}
\usage{
\method{expectancy}{BLC}(x, at = NULL, prob = 0.95, ...)
}
\arguments{
\item{x}{A \code{BLC} or \code{PredBLC} object.}

\item{at}{A number that determines at which age the expectancy life is calculated based on the ages used in fit or prediction. For instance, at = 0 is related to the first age used in fitted model.}

\item{prob}{A number that specifies the probability of the credible interval. Default is '0.95'.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A list that contains three vectors with the fitted values of life expectancy and the lower and upper limits of the credible intervals for each year used in fitted model or for the prediction.
}
\description{
Computes the fitted life expectancy for a specific age for each year in fit or prediction. It also calculates the limits of credible intervals.
}
\examples{
## Importing log-mortality data from Portugal:
data(PT)
Y <- PT

## Fitting the model
fit = blc(Y = Y, M = 100, bn = 20)

## Life expectancy for the years used in model fitted
expectancy(fit)

## Life expectancy for the tenth and thirtieth age in the years used in
## model fitted (27 and 47 y.o.)
expectancy(fit, at = c(10,30))

}
\seealso{
\code{\link[=expectancy.HP]{expectancy.HP()}} and \code{\link[=expectancy.DLM]{expectancy.DLM()}} for \code{HP} and \code{DLM} methods.

\code{\link[=Heatmap.BLC]{Heatmap.BLC()}} for \code{BLC} method to drawing a Heatmap for the truncated life expectancy.
}
