% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs_SFM_sp.R
\name{gibbs_SFM_sp}
\alias{gibbs_SFM_sp}
\title{Bayesian estimation of a mixture of Poisson distributions.}
\usage{
gibbs_SFM_sp(y, K, nb_iter, priors = list(), printing = TRUE)
}
\arguments{
\item{y}{Vector of discrete observations.}

\item{K}{Maximum number of mixture components.}

\item{nb_iter}{Number of MCMC iterations.}

\item{priors}{List of priors. Default is :
list(a0 = 1, A0 = 200, l0 = 5, L0 = l0 - 1)}

\item{printing}{Print intermediate output of the MCMC estimation ? default = TRUE.}
}
\value{
mcmc_draws : Parameter draws from the posterior distribution at each MCMC iteration. A (nb_iter x 3K + 1) matrix.
}
\description{
MCMC estimation using a sparse finite mixture (SFM) algorithm.
}
\references{
\insertRef{malsiner-walli_model-based_2016}{BayesMultiMode}\cr\cr
\insertRef{SFS:Mal:2019}{BayesMultiMode}
}
\keyword{internal}
