% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_BayesMixture.R
\name{new_BayesMixture}
\alias{new_BayesMixture}
\title{Creating a S3 object of class \code{BayesMixture}}
\usage{
new_BayesMixture(
  mcmc,
  data,
  K,
  burnin,
  dist = "NA",
  pars_names,
  pdf_func = NULL,
  dist_type
)
}
\arguments{
\item{mcmc}{A matrix of MCMC draws.}

\item{data}{A vector containing the data used for estimating the model and generating the MCMC draws.}

\item{K}{Number of mixture components.}

\item{burnin}{Number of draws to discard as burnin.}

\item{dist}{Distribution family of the mixture components supported by
the package (e.g. "normal", "student", "skew_normal" or "shifted_poisson").}

\item{pars_names}{Names of the mixture parameters; first element should 
correspond to the mixture proportions.}

\item{pdf_func}{Pdf or pmf of the mixture components;
this input is used only if dist_name is invalid or NULL.}

\item{dist_type}{Either "continuous" or "discrete".}
}
\value{
A list of class \code{BayesMixture} containing:
\itemize{
 \item{data}{ - Same as argument.}
 \item{dist_type}{ - Same as argument.}
 \item{pars_names}{ - Same as argument.}
 \item{mcmc}{ - Matrix of MCMC draws where the rows corresponding to burnin have been discarded.}
 \item{mcmc_all}{ - Original matrix of MCMC draws.}
}
}
\description{
Function for creating an object of class \code{BayesMixture} which can subsequently be used as argument in [bayes_mode()].
This function is useful for users who want to use the mode inference functions of the package with MCMC output generated using 
other software packages.
}
\examples{

# Example with a Student t ================================================
mu = c(0.5,6)
sigma = c(1,2)
nu = c(5,5)
p = c(0.8,0.2)
params = c(eta = p, mu = mu, sigma = sigma, nu = nu)
pars_names = c("eta", "mu", "sigma", "nu")
dist_type = "continuous"

data = c(sn::rst(p[1]*1000, mu[1], sigma[1], nu = nu[1]),
         sn::rst(p[2]*1000, mu[2], sigma[2], nu = nu[2]))

fit = c(eta = p, mu = mu, sigma = sigma, nu = nu)
fit = rbind(fit, fit)

pdf_func = function(x, pars) {
  sn::dst(x, pars["mu"], pars["sigma"], pars["xi"], pars["nu"])
}

BM = new_BayesMixture(fit, data, K = 2, burnin = 1,
pars_names = pars_names, pdf_func = pdf_func, dist_type = dist_type)

}
