% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D2_AbsorbEvidence.R
\name{AbsorbEvidence}
\alias{AbsorbEvidence}
\title{Absorb evidence into the model}
\usage{
AbsorbEvidence(tree, vars, values)
}
\arguments{
\item{tree}{a \code{\linkS4class{ClusterTree}} object}

\item{vars}{a \code{vector} of the names of observed variables}

\item{values}{a \code{list} of observed values of the variables. Aside from a single value,
The element of the list can also be a vector of likelihood values}
}
\value{
\code{\linkS4class{ClusterTree}} object with the evidence absorbed
}
\description{
Absorb evidence into the model
}
\details{
Absorb multiple types and pieces of evidences into a \code{\linkS4class{ClusterTree}}
object. The discrete compartment of the \code{\linkS4class{ClusterTree}} will be automatically
propagated after evidence absorption, so that the object will be ready for making
queries and absorbing additional evidence.
}
\examples{

data(liver)
tree.init.p <- Initializer(dag=liver$dag, data=liver$data,
                           node.class=liver$node.class,
                           propagate = TRUE)
tree.post <- AbsorbEvidence(tree.init.p, c("Nr1i3", "chr1_42.65"), list(1,"1"))

}
\references{
Cowell, R. G. (2005). Local propagation in conditional Gaussian Bayesian networks.
Journal of Machine Learning Research, 6(Sep), 1517-1550. \cr
\cr
Lauritzen, S. L., & Spiegelhalter, D. J. (1988). Local computations with probabilities on
graphical structures and their application to expert systems. Journal of the Royal Statistical
Society. Series B (Methodological), 157-224.
}
\author{
Han Yu
}
