% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCPO.R
\name{plotCPO}
\alias{plotCPO}
\title{plot the conditional predictive ordinate}
\usage{
plotCPO(
  x,
  outlier.mark = TRUE,
  outlier.thresh = 0.01,
  scale.CPO = TRUE,
  x.loc = FALSE,
  axis.label = NULL,
  las = 0,
  cex.axis = 1,
  mark.pos = c(0, -0.01),
  mark.color = 2,
  mark.cex = 0.8,
  xlab = "Observations",
  ylab = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class \code{BayesSUR}}

\item{outlier.mark}{mark the outliers with the response names. The default is \code{FALSE}}

\item{outlier.thresh}{threshold for the CPOs. The default is 0.01.}

\item{scale.CPO}{scaled CPOs which is divided by their maximum. The default is \code{TRUE}}

\item{x.loc}{a vector of features distance}

\item{axis.label}{a vector of predictor names which are shown in CPO plot. The default is \code{NULL} only showing the indices. The value \code{"auto"} show the predictor names from the original data.}

\item{las}{graphical parameter of plot.default}

\item{cex.axis}{graphical parameter of plot.default}

\item{mark.pos}{the location of the marked text relative to the point}

\item{mark.color}{the color of the marked text. The default color is red}

\item{mark.cex}{the font size of the marked text. The default font size is 0.8}

\item{xlab}{a title for the x axis}

\item{ylab}{a title for the y axis}

\item{...}{other arguments}
}
\description{
Plot the conditional predictive ordinate (CPO) for each individual of a fitted model generated by \code{BayesSUR} which is a \code{BayesSUR} object. CPO is a handy posterior predictive check 
because it may be used to identify outliers, influential observations, and for hypothesis testing across different non-nested models (Gelfand 1996).
}
\details{
The default threshold for the CPOs to detect the outliers is 0.01 by Congdon (2005). It can be tuned by the argument \code{outlier.thresh}.
}
\examples{
data("exampleEQTL", package = "BayesSUR")
hyperpar <- list( a_w = 2 , b_w = 5 )

set.seed(9173)
fit <- BayesSUR(Y = exampleEQTL[["blockList"]][[1]], 
                X = exampleEQTL[["blockList"]][[2]],
                data = exampleEQTL[["data"]], outFilePath = tempdir(),
                nIter = 100, burnin = 50, nChains = 2, gammaPrior = "hotspot",
                hyperpar = hyperpar, tmpFolder = "tmp/", output_CPO=TRUE)

## check output
# plot the conditional predictive ordinate (CPO)
plotCPO(fit)

}
\references{
Statisticat, LLC (2013). \emph{Bayesian Inference.} Farmington, CT: Statisticat, LLC.

Gelfand A. (1996). \emph{Model Determination Using Sampling Based Methods}. In Gilks W., Richardson S., Spiegelhalter D. (eds.), Markov Chain Monte Carlo in Practice, pp. 145–161. Chapman & Hall, Boca Raton, FL.

Congdon P. (2005). \emph{Bayesian Models for Categorical Data}. John Wiley & Sons, West Sussex, England.
}
