% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions-weightfunctions.R
\name{weightfunctions}
\alias{weightfunctions}
\alias{mdone.sided}
\alias{mdtwo.sided}
\alias{mdone.sided_fixed}
\alias{mdtwo.sided_fixed}
\alias{rone.sided}
\alias{rtwo.sided}
\alias{rone.sided_fixed}
\alias{rtwo.sided_fixed}
\alias{mpone.sided}
\alias{mptwo.sided}
\alias{mpone.sided_fixed}
\alias{mptwo.sided_fixed}
\alias{mqone.sided}
\alias{mqtwo.sided}
\alias{mqone.sided_fixed}
\alias{mqtwo.sided_fixed}
\title{Weight functions}
\usage{
mdone.sided(x, alpha = NULL, alpha1 = NULL, alpha2 = NULL, log = FALSE)

mdtwo.sided(x, alpha, log = FALSE)

mdone.sided_fixed(x, omega, log = FALSE)

mdtwo.sided_fixed(x, omega, log = FALSE)

rone.sided(n, alpha = NULL, alpha1 = NULL, alpha2 = NULL)

rtwo.sided(n, alpha)

rone.sided_fixed(n, omega)

rtwo.sided_fixed(n, omega)

mpone.sided(
  q,
  alpha = NULL,
  alpha1 = NULL,
  alpha2 = NULL,
  lower.tail = TRUE,
  log.p = FALSE
)

mptwo.sided(q, alpha, lower.tail = TRUE, log.p = FALSE)

mpone.sided_fixed(q, omega, lower.tail = TRUE, log.p = FALSE)

mptwo.sided_fixed(q, omega, lower.tail = TRUE, log.p = FALSE)

mqone.sided(
  p,
  alpha = NULL,
  alpha1 = NULL,
  alpha2 = NULL,
  lower.tail = TRUE,
  log.p = FALSE
)

mqtwo.sided(p, alpha, lower.tail = TRUE, log.p = FALSE)

mqone.sided_fixed(p, omega, lower.tail = TRUE, log.p = FALSE)

mqtwo.sided_fixed(p, omega, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{x, q}{vector or matrix of quantiles.}

\item{alpha}{vector or matrix with concentration parameters for
the Dirichlet distribution for a monotonic one.sided or a two.sided
weight function.}

\item{alpha1}{vector or matrix with concentration parameters for
the Dirichlet distribution for the expected direction of non-monotonic
one.sided of weight function.}

\item{alpha2}{vector or matrix with concentration parameters for
the Dirichlet distribution for the unexpected direction of non-monotonic
one.sided of weight function.}

\item{log, log.p}{logical; if \code{TRUE}, probabilities
\code{p} are given as \code{log(p)}.}

\item{omega}{vector or matrix of fixed probabilities for a one.sided or
a two.sided weight function.}

\item{n}{number of observations.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities
are \eqn{P[X \le x]}, otherwise, \eqn{P[X \ge x]}.}

\item{p}{vector of probabilities.}
}
\value{
\code{mdone.sided}, \code{mdtwo.sided}, \code{mdone.sided_fixed},
and \code{mdtwo.sided_fixed} give the marginal density,
\code{mpone.sided}, \code{mptwo.sided}, \code{mpone.sided_fixed},
and \code{mptwo.sided_fixed} give the marginal distribution function,
\code{mqone.sided}, \code{mqtwo.sided}, \code{mqone.sided_fixed},
and \code{mqtwo.sided_fixed} give the marginal quantile function,
and \code{rone.sided}, \code{rtwo.sided}, \code{rone.sided_fixed},
and \code{rtwo.sided_fixed} generate random deviates.
}
\description{
Marginal density, marginal distribution function,
marginal quantile function and random generation for weight functions.
}
\examples{
# draw samples from a two-sided weight function
rtwo.sided(10, alpha = c(1, 1))

# draw samples from a monotone one-sided weight function
rone.sided(10, alpha = c(1, 1, 1))

# draw samples from a non-monotone one-sided weight function
rone.sided(10, alpha1 = c(1, 1), alpha2 = c(1, 1))

}
