% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-averaging.R
\name{as_mixed_posteriors}
\alias{as_mixed_posteriors}
\title{Export BayesTools JAGS model posterior distribution as model-average posterior distributions via \code{mix_posteriors}}
\usage{
as_mixed_posteriors(
  model,
  parameters,
  conditional = NULL,
  conditional_rule = "AND",
  force_plots = FALSE
)
}
\arguments{
\item{model}{model fit via the \link{JAGS_fit} function}

\item{parameters}{vector of parameters names for which inference should
be drawn}

\item{conditional}{a character vector of parameters to be conditioned on}

\item{conditional_rule}{a character string specifying the rule for conditioning.
Either "AND" or "OR". Defaults to "AND".}

\item{force_plots}{temporal argument allowing to generate conditional posterior samples
suitable for prior and posterior plots. Only available when conditioning on a
single parameter.}
}
\value{
\code{as_mix_posteriors} returns a named list of mixed posterior
distributions (either a vector of matrix).
}
\description{
Creates a model-averages posterior distributions on a single
model that allows mimicking the \link{mix_posteriors} functionality. This function
is useful when the model-averaged ensemble is based on \link{prior_spike_and_slab}
or \link{prior_mixture} priors - the model-averaging is done within the model.
}
\seealso{
\link{mix_posteriors}
}
