% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors-tools.R
\name{is.prior}
\alias{is.prior}
\alias{is.prior.point}
\alias{is.prior.none}
\alias{is.prior.simple}
\alias{is.prior.vector}
\alias{is.prior.PET}
\alias{is.prior.PEESE}
\alias{is.prior.weightfunction}
\alias{is.prior.factor}
\alias{is.prior.orthonormal}
\alias{is.prior.dummy}
\title{Reports whether x is a a prior object}
\usage{
is.prior(x)

is.prior.point(x)

is.prior.none(x)

is.prior.simple(x)

is.prior.vector(x)

is.prior.PET(x)

is.prior.PEESE(x)

is.prior.weightfunction(x)

is.prior.factor(x)

is.prior.orthonormal(x)

is.prior.dummy(x)
}
\arguments{
\item{x}{an object of test}
}
\value{
returns a boolean indicating whether the test object
is a prior (of specific type).
}
\description{
Reports whether x is a a prior object. Note that
point priors inherit the prior.simple property
}
\examples{
# create some prior distributions
p0 <- prior(distribution = "point",  parameters = list(location = 0))
p1 <- prior_PET(distribution = "normal", parameters = list(mean = 0, sd = 1))

is.prior(p0)
is.prior.simple(p0)
is.prior.point(p0)
is.prior.PET(p0)

is.prior(p1)
is.prior.simple(p1)
is.prior.point(p1)
is.prior.PET(p1)

}
