
#' @title    Draw the FROC  curves with Colour
#'@description     Draw an FROC  curves and an AFROC curves for user's specified modality and user's specified reader.
#' Using this function \strong{repeatedly}, we can draw the different reader and modality in a  \strong{same} plane simultaneously.
#' So, we can visualize the difference of modality (reader).
#'
#'    --------   To read the tables in Stan S4 class  ----------------------------
#'
#'
#'   * The  AUC denoted by AA[modalityID , readerID] are shown.
#'
#'   * The column of 2.5\% and 97.5\% means the lower and upper bounds of the 95% Credible Interval of AUCs.
#'
#'   * For example, AA[2,3] means the AUC of the 2 nd modality and the 3 rd reader.
#'

#'
#'
#'@param DrawFROCcurve TRUE or FALSE. Whether or not FROC curves are shown.
#'@param DrawAFROCcurve TRUE or FALSE. Whether or not AFROC curves are shown.
#'@param DrawCFPCTP TRUE or FALSE. Whether or not CFPCTP points are shown.
#'@param Draw.Flexible.upper_y TRUE or FALSE. Whether or not the upper bounds of vertical axis are determined automatically.
#'@param Draw.Flexible.lower_y TRUE or FALSE. Whether or not the lower bounds of vertical axis are determined automatically.
#'@param StanS4class This is an output of \code{rstan::stan()}. More precisely, an object of the inherited class of the S4 class stanfit.
#'That is, the stanfitExtended S4 class defined in this package.

#'
#'@param modalityID This is a vector indicating modalityID.
#'@param readerID  This is a vector indicating readerID.
#'
#'
#'@param Colour TRUE or FALSE. Colour of curves.

#'
#'@inheritParams fit_Bayesian_FROC
#'
#'@examples
#'
#' \donttest{
# ####1#### ####2#### ####3#### ####4#### ####5#### ####6#### ####7#### ####8#### ####9####

#' #1) Build the S4 class object by the following:
#'
#'
#'
#'   fit <- fit_Bayesian_FROC(dataList.Chakra.Web)
#'
#'
#' # The object "fit" is an S4 class object
#' # whose S4 class name is stanfit in the rstan package.
#'
#' #<<Minor comments>>
#' #Note that return value "fit" is not an stanfit S4 object generated by rstan::stan(),
#' #but some inherited S4 class object which is an S4 object of
#' # some inherited S4 class from stanfit class. So, we can consider it as an object of
#' #an S4 class of rstan::stan().
#' #2) Now, we obtain the S4 class object named "fit".
#'   # Using this S4 class object, we draw the curves by:
#'
#'
#'
#'  DrawCurves_MRMC_pairwise(fit,
#'                           modality = 1,
#'                           reader = 4
#'                           )
#'
#'
#'
#' #3) By changing, e.g., the modality,
#'    #we can draw the curves for different  modalities.
#'    #This shows the comparison of modalites.
#'
#'
#'
#'  DrawCurves_MRMC_pairwise(fit,
#'                           modality = 2,
#'                           reader = 4
#'                           )
#'
#'  DrawCurves_MRMC_pairwise(fit,
#'                           modality = 3,
#'                           reader = 4
#'                           )
#'
#'
#' #4) By repeat the running with respect to different modalities
#' #   in this manner, we can draw  AFROC (FROC) curves.
#'
#'
#'
#' #5) If you want to draw the FROC curves
#' #for reader ID =1,2,3,4 and modality ID =1,2, then the code is as follows;
#'
#' DrawCurves_MRMC_pairwise(
#'                             fit,
#'                             modalityID = c(1,2,3,4),
#'                             readerID = c(1,2)
#'                             )
#'# Each color of curves corresponds to the modality ID.
#'# So, even if curves are different readers and same modality, then color is same.
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'
#'        #    Close the graphic device
#'
#'        Close_all_graphic_devices()
#'        } # dottest

#'@inheritParams fit_Bayesian_FROC
#' @export DrawCurves_MRMC_pairwise
#'
#'
DrawCurves_MRMC_pairwise<- function(
   StanS4class,
  modalityID,
  readerID,
  Colour=TRUE,
  DrawFROCcurve=TRUE,
  DrawAFROCcurve=FALSE,
  DrawCFPCTP=TRUE,
  Draw.Flexible.upper_y=TRUE,
  Draw.Flexible.lower_y=TRUE,
  new.imaging.device = TRUE


)
{






  if(Colour==TRUE){ DrawCurves_MRMC_pairwise_col(
     StanS4class = StanS4class,
     modalityID = modalityID,
    readerID = readerID,
    new.imaging.device = new.imaging.device,

    DrawFROCcurve = DrawFROCcurve,
    DrawAFROCcurve = DrawAFROCcurve,
    DrawCFPCTP = DrawCFPCTP,
    Draw.Flexible.upper_y = Draw.Flexible.upper_y,
    Draw.Flexible.lower_y = Draw.Flexible.lower_y
  )}

  if(Colour==FALSE){ DrawCurves_MRMC_pairwise_BlackWhite(
     StanS4class = StanS4class,
     modalityID = modalityID,
    readerID = readerID,
    new.imaging.device = new.imaging.device,

    DrawFROCcurve = DrawFROCcurve,
    DrawAFROCcurve = DrawAFROCcurve,
    DrawCFPCTP = DrawCFPCTP,
    Draw.Flexible.upper_y = Draw.Flexible.upper_y,
    Draw.Flexible.lower_y = Draw.Flexible.lower_y
  )}

  if(!Colour==FALSE && !Colour==TRUE ){ warning("Colour is TRUE or FALSE")}



}
