% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConfirmConvergence.R
\name{ConfirmConvergence}
\alias{ConfirmConvergence}
\title{Diagnosis For Convergence}
\usage{
ConfirmConvergence(StanS4class, summary = TRUE)
}
\arguments{
\item{StanS4class}{That is an S4 object, whose class is named \code{stanfit} in the rstan package. This is an output of \code{rstan::stan()}, and not restricted in the author's Bayesian model.}

\item{summary}{TRUE or FALSE. If TRUE then summary and estimates are printed in the R console. If FALSE, the output is minimal.}
}
\value{
TRUE of FALSE. If model converges then TRUE, and if not FALSE.
}
\description{
This function evaluate your model's R hat statistics.
}
\examples{
\donttest{
#================The first example======================================

            #((Primitive way)).
#1) Build the data for singler reader and single modality  case.

dat <- list(c=c(3,2,1),    #Confidence level
            h=c(97,32,31), #Number of hits for each confidence level
            f=c(1,14,74),  #Number of false alarms for each confidence level

            NL=259,       #Number of lesions
            NI=57,        #Number of images
            C=3)          #Number of confidence level

# where, c denotes Confidence level,
#        h denotes number of Hits for each confidence level,
#        f denotes number of False alarms for each confidence level,
#        NL denotes Number of Lesions,
#        NI denotes Number of Images,


#2) Fit the FROC model.
  #Since dataset named dat are single reader and single modality,
  #the function build the such model by running the following code.

          fit <-   BayesianFROC::fit_Bayesian_FROC(dat,ite=111)


#3.1) Confirm whether or not our model converges.


       ConfirmConvergence(fit)





# The following is useful for programming.
#3.2) The return value is TRUE or FALSE.

     x <- ConfirmConvergence(fit)

#3.3) If you do not want to print the results, then

      x <- ConfirmConvergence(fit,summary=FALSE)


}# dottest
}
\references{
Gelman A. \&  Rubin, D.B. (1992). Inference from Iterative Simulation Using Multiple Sequences, Statistical Science, Volume 7, Number 4, 457-472.
}
\seealso{
\code{check_rhat()} made by Betanalpha.
}
